<?php
$date_format = cs_get_option( 'date_format' );
?>

<div class="post-grid post">
    <?php
        $args = array (
            'post_type'      => 'post',
            'post_status'    => $atts['status'],
            'posts_per_page' => $atts['number'],
            'order'          => $atts['order'],
            'orderby'        => $atts['orderby'],
            'category_name'  => $atts['categories'],
        );
        $massivePostsQuery = new WP_Query( $args );
        $i = 0;
        if ( $massivePostsQuery->have_posts() ) {
            while ( $massivePostsQuery->have_posts() ) {
                $massivePostsQuery->the_post();
                $categories = get_the_category();
                $i++;
                ?>
                <div class="col-md-4">
                    <div class="post-single">
                        <?php if ( ( $i % 2 ) == 0 ) { ?>
                            <div class="post-desk">
                                <div class="mid-align">
                                    <div class="date dark-text">
                                        <?php echo get_the_time( $date_format ); ?>
                                    </div>
                                    <h4 class="text-uppercase">
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </h4>
                                    <ul class="post-cat">
                                        <li><?php massive_get_post_categories( $categories, ' &nbsp;' ); ?></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="post-img top">
                                <?php include ( dirname( __FILE__ ) . '/content/content.php' ); ?>
                            </div>
                        <?php } else { ?>
                            <div class="post-img bottom">
                                <?php include ( dirname( __FILE__ ) . '/content/content.php' ); ?>
                            </div>
                            <div class="post-desk">
                                <div class="mid-align">
                                    <div class="date dark-text">
                                        <?php echo get_the_time( $date_format ); ?>
                                    </div>
                                    <h4 class="text-uppercase">
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </h4>
                                    <ul class="post-cat">
                                        <li><?php massive_get_post_categories( $categories, ' &nbsp;' ); ?></li>
                                    </ul>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
        <?php   }
        } else {
            echo '<p>'. esc_html__('no posts found', 'massive-engine') .'</p>';
        }
        wp_reset_postdata();
     ?>
</div> <!-- .post-grid -->
