<?php
/**
 * Shortcode base class
 * All shortcodes should be extended from this class
 */
class Massive_Shortcode_Base {

    /**
     * Extended class file location
     * @var string
     */
    protected $location;

    /**
     * Get shortcode tag name
     * @return string
     */
    protected function get_tag() {
        return strtolower( get_called_class() );
    }

    /**
     * Get shortcode view file
     * @param string $view Shortcode view name
     * @return string
     */
    protected function get_view( $view = '' ) {
        $location = trailingslashit( $this->location );
        return trailingslashit( $location . 'views' ) . trim( $view ) . '.php';
    }

    /**
     * Generate unique id
     * @param  array $params
     * @return string
     */
    protected function get_uid( $params ) {
        $str = get_called_class();
        if ( is_array( $params ) ) {
            $params['uid'] = '';
            $str .= http_build_query( $params );
        }
        return 'Massive' . md5( $str );
    }

    /**
     * Create icon url
     * @param $name          Shortcode icon name
     * @param string $ext    Icon extension
     * @return string        Shortcode icon url
     */
    protected function get_icon( $name, $ext = 'png' ) {
        $dir = trailingslashit( MASSIVE_ENGINE_URL . 'assets/icons' );
        return esc_url( $dir . $name . ".{$ext}" );
    }

}