<?php
$excerpt_length = $atts['excerpt_length'];
$date_format    = cs_get_option( 'date_format' );
$args           = array (
    'post_type'      => 'post',
    'post_status'    => $atts['status'],
    'posts_per_page' => $atts['number'],
    'order'          => $atts['order'],
    'orderby'        => $atts['orderby'],
    'category_name'  => $atts['categories'],
  );
  $massivePostsQuery = new WP_Query( $args );
  if ( $massivePostsQuery->have_posts() ) {
      while ( $massivePostsQuery->have_posts() ) {
      $massivePostsQuery->the_post();
      $categories = get_the_category();
?>
  <div class="post-list-aside post">
    <div class="post-single">
        <div class="col-md-5">
            <div class="post-img">
                <?php include ( dirname( __FILE__ ) . '/content/content.php' ); ?>
            </div>
        </div>

        <div class="col-md-7">
            <div class="post-desk text-center">
                <ul class="post-cat">
                    <li><?php massive_get_post_categories( $categories, ' &nbsp;' ); ?></li>
                </ul>
                <h4 class="text-uppercase">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h4>
                <div class="date">
                  <?php massive_author_link();?> | <?php echo get_the_time( $date_format ); ?>
                </div>
                <p><?php echo wp_trim_words( get_the_content(), $excerpt_length, '...' ); ?></p>
                <?php echo '<a href="' . esc_url( get_the_permalink() ) .'" class="p-read-more">'. esc_html__("Read More", 'massive-engine').'<i class="icon-arrows_slim_right"></i></a>'; ?>
            </div>
        </div>
    </div>
  </div>
<?php   }
} else {
    echo '<p>'. esc_html__('no posts found', 'massive-engine') .'</p>';
}
wp_reset_postdata();
?>
